clear all
%path for sagving the figures as pdf
addpath(genpath('S:\AG Wegener\MechaMeta\Youngsmodulus Tuning Fork\Messung\Functions\exportfig'))

subfolders = dir();
subfolders(~[subfolders.isdir]) = []; %remove non-directory entries
subfolders = subfolders(3:end);% remove '.' and '..'

phase_angle_result=[];
phase_angle_result_top=[];
phase_angle_result_bottom=[];
frequency_result=[];
result_frequency=[];
result_amplitude_side=[];
result_amplitude_side_fault=[];
result_amplitude_top=[];


tab_norm=[];
tab_norm_fault=[];
tab_amp=[];
tab_amp_fault=[];


freq_counter_bottom=0;
for freq_number=1:length(subfolders)   
    foldername = subfolders(freq_number).name;
    %display(freq_number)
    cd(foldername) 
    %assert(exist(filename,'file') ~= 2, 'File not found.' );
    [filepath,name,ext]=fileparts(pwd);
    view=strfind(name,'side');
    if (length(view)~=0)
        counter = 1;
        adress_bottom1='validx_sideview_bottom.dat';
        adress_bottom2='validy_sideview_bottom.dat';
        if isfile(adress_bottom1)
            automate_evaluation_pro
        end
    end
   
    adress_bottom3='validx_sideview_top_left.dat';
    adress_bottom4='validy_sideview_top_left.dat';
    adress_comparison1=replace(adress_bottom3,'left.dat','right.dat');
    adress_comparison2=replace(adress_bottom4,'left.dat','right.dat');
    if (length(view)~=0)
        counter = 2;
        if isfile(adress_bottom3)
            automate_evaluation_pro_bottom_phase
        end    
    end
    
    cd ../   
end

% subfolders = dir();
% subfolders(~[subfolders.isdir]) = []; %remove non-directory entries
% subfolders = subfolders(3:end);% remove '.' and '..'
% 
for freq_number=1:length(subfolders)    
    foldername = subfolders(freq_number).name;
    %display(freq_number)
    cd(foldername)   
    %assert(exist(filename,'file') ~= 2, 'File not found.' );
    [filepath,name,ext]=fileparts(pwd);
    view=strfind(name,'top');
    if (length(view)~=0)
        adress_top1='validx_topview_bottom.dat';
        adress_top2='validy_topview_bottom.dat';
        adress_comparison1=replace(adress_top1,'bottom.dat','top.dat');
        adress_comparison2=replace(adress_top2,'bottom.dat','top.dat');
        if isfile(adress_top1)
           % automate_evaluation_pro_top_comparison
        end      
    end   
    cd ../  
end
%guess for the maximum of the frequency
guess_maximum=result_frequency(find(result_amplitude_side==max(result_amplitude_side)));


figure;
double_result_amplitude=result_amplitude_side.*result_amplitude_side;
double_result_amplitude_side=double_result_amplitude;
err_bar=result_amplitude_side_fault.*result_amplitude_side*2;
plot(result_frequency(:),result_amplitude_side(:),'.')
xlabel('frequency in kHz')
ylabel('Maximum displacement in units of the excitation amplitude')
legend('datapoint')
title('Resonance Plot sideview')
plot_counter=1;
automate_evaluation_fit
savefig('sideview_amplitude_result');
export_fig sideview_amplitude_result;


figure;
double_result_amplitude=result_amplitude_top.*result_amplitude_top;
double_result_amplitude_top=double_result_amplitude;
plot(result_frequency(:),result_amplitude_top(:),'.')
xlabel('frequency in kHz')
ylabel('Maximum displacement in units of the excitation amplitude')
legend('datapoint')
title('Resonance Plot topview')
plot_counter=2;
automate_evaluation_fit
savefig('topview_amplitude_result');
export_fig topview_amplitude_result;

for p=1:length(phase_angle_result_top)
    phase_angle_result(p)=-phase_angle_result_top(p)+phase_angle_result_bottom(p);
    if phase_angle_result(p)<0
    phase_angle_result(p)=2+phase_angle_result(p);    
    end
end

% for p=1:length(phase_angle_result_top)
%     if phase_angle_result_top(p)<phase_angle_result_bottom(p)
%     phase_angle_result(p)=2+phase_angle_result_top(p)-phase_angle_result_bottom(p);
%     
%     else
%     phase_angle_result(p)=phase_angle_result_top(p)-phase_angle_result_bottom(p);
%     end
% end

figure;
title('Phase angle')
plot(result_frequency(:),phase_angle_result(:),'.')
ylabel('Phase angle in units of \pi')
xlabel('frequency in kHz')
automate_evaluation_fit_2
[filepath,name,ext]=fileparts(pwd);
savefig('phase_angle_result');
export_fig phase_angle_result;

%average of side and topview

figure;
double_result_amplitude=(double_result_amplitude_side+double_result_amplitude_top)/2;
plot(result_frequency(:),result_amplitude_top(:),'.')
xlabel('frequency in kHz')
ylabel('Maximum displacement in units of the excitation amplitude')
legend('datapoint')
title('Resonance Plot topview')
plot_counter=3;
automate_evaluation_fit
savefig('result_amplitude_mean');
export_fig result_amplitude_mean;

savepath=fullfile(filepath,name,'result_amplitude.dat' );
save(fullfile(filepath,name,'result_amplitude_top.dat' ) ,  'result_amplitude_top', '-ascii' ,'-tabs');
save(fullfile(filepath,name,'result_amplitude_side.dat' ) ,  'result_amplitude_side', '-ascii' ,'-tabs');
save(fullfile(filepath,name,'result_amplitude_side_fault.dat' ) ,  'result_amplitude_side_fault', '-ascii' ,'-tabs');

save( fullfile(filepath,name,'result_frequency.dat' ),  'result_frequency', '-ascii' ,'-tabs');
save(fullfile(filepath,name,'result_phase_angle.dat' ),  'phase_angle_result', '-ascii' ,'-tabs');

